-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local TableUtils = plugins.style:lazyRequire('utils.TableUtils')
local PropertyTypes = plugins.style:lazyRequire('rules.styles.definitions.PropertyTypes')
local TypeRuntimeExpression = plugins.style:lazyRequire('expressions.definitions.TypeRuntimeExpression')

--
-- Function representing the 'Rect' type used for sizes/dimensions etc.
--
-- Generates a TypeRuntimeExpression for which will create a LuaRect CDATA when
-- evaluated at runtime.
--
return function(top, bottom, left, right)
	local values = { top, bottom, left, right }

	assert(#values == 4, 'Rect takes exactly four arguments')
	assert(TableUtils.allOfType(values, 'number'), 'Rect arguments must be numbers')

	return TypeRuntimeExpression.new(PropertyTypes.RECT, values)
end
