-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local RgbColor = plugins.style:lazyRequire('expressions.definitions.types.RgbColorType')

--
-- Converts a hex string (e.g. #FFCC00) to a Vec3
--
return function(hexString)
	assert(#hexString == 7, 'HexColor string must contain 7 characters')
	assert(hexString:sub(1, 1) == '#',
			'First character of an HexColor string must be a \'#\'')

	hexString = hexString:gsub("#","")
	local red   = tonumber("0x" .. hexString:sub(1,2))
	local green = tonumber("0x" .. hexString:sub(3,4))
	local blue  = tonumber("0x" .. hexString:sub(5,6))

	return RgbColor(red, green, blue)
end
