-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local Vec3 = plugins.style:lazyRequire('expressions.definitions.types.Vec3Type')

local function validRange(value)
	return (value >= 0) and (value <= 255)
end

--
-- Converts a value representing the intensity of the grayscale color
--( between 0 and 255) to a normalized Vec3 (values between 0 and 1)
--
return function(intensity)
	assert(type(intensity) == 'number', 'GrayscaleColor argument must be a number')
	assert(validRange(intensity), '"intensity" argument of GrayscaleColor must be between 0 and 255')

	return Vec3(intensity/255.0, intensity/255.0, intensity/255.0)
end
