-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local Iterators = plugins.style:lazyRequire("expressions.definitions.iterators.Iterators")
require('pl.compat')

-- Creates an iterator function for each Iterator type listed in the Iterators
-- table.
local function loadIteratingFunctions(into)
	local namespace = into or _G

	for iteratorName, _ in pairs(Iterators) do
		-- Creates a description for the iterator that has to be
		-- created by the RuleApplier
		namespace[iteratorName] = function(...)
			return {
				isIterator = true,
				iterator = iteratorName,
				args = table.pack(...)
			}
		end
	end
end

-- Reverses the action of loadIteratingFunctions(), either on the supplied
-- table or on the global namespace.
local function unloadIteratingFunctions(from)
	local namespace = from or _G

	for iteratorName, _ in pairs(Iterators) do
		namespace[iteratorName] = nil
	end
end

-- Public exports.
return
{
	loadIteratingFunctions = loadIteratingFunctions,
	unloadIteratingFunctions = unloadIteratingFunctions
}
