-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local _idCounter = 0

--
-- Base class for all RuntimeExpressions
--
local AbstractRuntimeExpression = class()

local TABLE_TYPE = 'table'

function AbstractRuntimeExpression:_init(expressionType)

	self._expressionType = expressionType

	_idCounter = _idCounter + 1
	self._id = _idCounter

	-- Used by ExpressionEvaluator when checking if a value is an expression.
	self.isExpression = true

end

function AbstractRuntimeExpression:getId()
	return self._id
end

function AbstractRuntimeExpression:getExpressionType()
	return self._expressionType
end

function AbstractRuntimeExpression:getAssociatedProperty()
	return self._associatedProperty
end

function AbstractRuntimeExpression:setAssociatedProperty(associatedProperty)
	self._associatedProperty = associatedProperty
end

function AbstractRuntimeExpression:getContext()
	return self._context
end

function AbstractRuntimeExpression:setContext(context)
	self._context = context
end

function AbstractRuntimeExpression.isExpression(value)
	return type(value) == TABLE_TYPE and value.isExpression
end

function AbstractRuntimeExpression.isExpressionTable(value)
	return type(value) == TABLE_TYPE and value.isExpressionTable
end

return AbstractRuntimeExpression



