-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractWatcher = plugins.style:lazyRequire('expressions.bindings.watchers.AbstractWatcher')

--
-- Watcher used with PropertyRuntimeExpressions so that they may be re-evaluated
-- when a watched property of a node is updated.
--
local BridgeWatcher = class(

	-- Parent class
	AbstractWatcher,

	-- Constructor
	function(self, bridge, variableName)

		self._bridge = bridge
		self._variableName = variableName
		self._cachedValue = self:_getWatchedValue()

		-- Bridge watchers must always be live, as they're watching for
		-- external changes.
		self:setIsLive(true)

	end
)

-- Returns the variable being watched by this watcher.
function BridgeWatcher:getVariableName()
	return self._variableName
end

function BridgeWatcher:_getWatchedValue()
	return self._bridge:getVariable(self._variableName)
end

return BridgeWatcher



