-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local StyleApplicationPhases = plugins.style:lazyRequire('rules.styles.StyleApplicationPhases')

--
-- Associates a node to a PropertyStyle so that the style may be re-applied when
-- the whatever the binding is bound to (something like a PropertyWatcher or a
-- BridgeVariable) is updated.
--
local Binding = class(function(self, node, propertyStyle, watcher)

	self._node = node
	self._propertyStyle = propertyStyle
	self._watcher = watcher

end)

local BINDING_UPDATE = StyleApplicationPhases.BINDING_UPDATE

-- Reapplies the PropertyStyle associated with this binding.
function Binding:update()
	self._propertyStyle:applyToNode(self._node, BINDING_UPDATE)
end

-- Returns the node which will have its property changed when this binding updates.
function Binding:getNode()
	return self._node
end

-- Returns the property style that should be update when this binding updates.
function Binding:getPropertyStyle()
	return self._propertyStyle
end

-- Returns the watcher which is driving updates of this binding.
function Binding:getWatcher()
	return self._watcher
end

return Binding



