
--[[

    Special effect type used when the stylesheet author wants to remove an
    effect that was added by a previous rule. Usage is as follows:

        -- Fades out all images
        to "ImageNode" apply
        {
            effects =
            {
                fade = Alpha(0)
            }
        }

        -- Removes the alpha effect for images that have a 'visible' tag
        to "ImageNode.visible" apply
        {
            effects =
            {
                fade = Remove()
            }
        }

    Note that the reason for having this effect rather than simply setting
    the value to nil is that Lua is unable to differentiate between values
    in a table that are explicitly set to nil and values that just not actually
    present - see http://lua-users.org/wiki/StoringNilsInTables for more info.

  ]]--

local EffectFactory = plugins.style:lazyRequire('effects.EffectFactory')

return EffectFactory.createEffectDefinition('remove')