-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local NamespacedAssetGetter = class(function(self, assetLibrary, namespace)
	self._assetLibrary = assetLibrary
	self._namespace = namespace
	self._definedAssets = {}
end)

function NamespacedAssetGetter:getImage(path)
	local id = self._namespace .. "::" .. path
	local finalPath

	if self._definedAssets[id] == true then
		finalPath = self._assetLibrary:getAsset(id):getSource()
	else
		local source = self._assetLibrary:getAssetPath(self._namespace)
				.. "images/" .. path

		self._assetLibrary:defineAsset
		{
			name = id,
			source = source,
			preload = false
		}

		self._definedAssets[id] = true
		finalPath = self._assetLibrary:getAsset(id):getSource()
	end
	return finalPath
end

function NamespacedAssetGetter:getStylesheet(path)
	return self._assetLibrary:getAssetPath(self._namespace) .. 'stylesheets/' .. path
end

return NamespacedAssetGetter