-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AssetGetterFactory = {}

-- This function returns a generic 'AssetGetter' object for the given asset
-- library. To retrieve the AssetGetter for a specific namespace, just
-- use the namespace as a key in the return object. E.g.
--
--   assetLibrary:registerAssetPath("MyPackage", "aPath")
--   local Assets = AssetGetterFactory.createGetterForAssetLibrary(assetLibrary)
--
--   local myImage = Assets.MyPackage:getImage("anImagePath")
function AssetGetterFactory.createGetterForAssetLibrary(assetLibrary)
	local metatable =
	{
		__index = function(selfObj, key)
			return assetLibrary:getAssetGetterForNamespace(key)
		end
	}

	local assetGetter = {}
	setmetatable(assetGetter, metatable)
	return assetGetter
end

return AssetGetterFactory