
local Asset = class(function(self, attributes)

	assert(attributes ~= nil, "The attributes argument to Asset.new() is required")
	assert(type(attributes.name) == "string", "Assets must have a 'name' attribute")
	assert(type(attributes.source) == "string", "Assets must have a 'source' attribute")

	self._name = attributes.name
	self._source = attributes.source

	-- Preload defaults to true if no value is specified.
	self._preload = (attributes.preload ~= false) and true or false

end)

function Asset:getName()
	return self._name
end

function Asset:getSource()
	return self._source
end

function Asset:getPreload()
	return self._preload
end

return Asset



