-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ffi = require('ffi')

local StyleValueFormatter = class()

function StyleValueFormatter.formatValue(value)
	if ffi.istype(LuaVec2, value) then
		return '[ ' .. value.x .. ', ' .. value.y .. ' ]'
	elseif ffi.istype(LuaVec3, value) then
		return '[ ' .. value.x .. ', ' .. value.y .. ', ' .. value.z .. ' ]'
	elseif ffi.istype(LuaVec4, value) then
		return '[ ' .. value.x .. ', ' .. value.y .. ', ' .. value.z .. ', ' .. value.w .. ' ]'
	elseif ffi.istype(LuaPivotMode, value) then
		return '[ ' .. value.x .. ', ' .. value.y .. ', ' .. value.z .. ' ]'
	elseif type(value) == 'table' and type(value.toString) == 'function' then
		return value:toString()
	else
		return tostring(value)
	end
end

return StyleValueFormatter