
local ffi = lazyRequire('ffi')

local function getTags(node)

	local numTags = node:numberOfTags()
	local tags = ffi.new('const char*[' .. numTags .. ']', {})
	node:getTags(tags)

	local strings = {}
	for i = 0, numTags-1 do
		strings[i] = ffi.string(tags[i])
	end

	return strings

end

local function getTagsAsHashes(node)

	local numTags = node:numberOfTags()
	local tags = ffi.new('hash_t[' .. numTags .. ']', {})
	node:getTagsAsHashes(tags)

	return tags

end

local function getTagsDebugString(node)
	local tagsString = ""
	local tags = getTags(node)
	local numTags = node:numberOfTags()
	for i = 0, numTags - 1 do
		tagsString = tagsString .. tags[i]
	end

	return tagsString
end

local function getTypeHierarchyDebugString(node)
	local typeString = ""
	local currentNode = node
	while currentNode ~= nil do
		typeString = typeString .. ffi.string(currentNode:getType()) .. " "
		currentNode = currentNode:getParent()
	end

	return typeString
end


-- Public exports.
return
{
	getTags = getTags,
	getTagsAsHashes = getTagsAsHashes,
	getTagsDebugString = getTagsDebugString,
	getTypeHierarchyDebugString = getTypeHierarchyDebugString,
	getChildren = getChildren,
}