-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local FileWriter = class(function(self, ioInstance, logInstance)
	-- Allows the io and log references to be stubbed during testing
	self._io  = ioInstance or io
	self._log = logInstance or log
end)

function FileWriter:writeFile(path, content)
	local file, err = self._io.open(path, 'w')

	if file == nil then
		self._log.error('Could not open file: ' .. err)
		return false
	else
		self._io.output(file)
		self._io.write(content)
		self._io.close(file)
		return true
	end
end

return FileWriter