-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local DirectoryUtils = class(function(self, lfsInstance, logInstance)
	-- Allows the lfs and log references to be stubbed during testing
	self._lfs = lfsInstance or lazyRequire("lfs")
	self._log = logInstance or log
end)

function DirectoryUtils:ensureDirectoryExists(path)
	local attributes, err = self._lfs.attributes(path)

	if attributes == nil then
		local couldCreate, err = self._lfs.mkdir(path)

		if couldCreate ~= true then
			self._log.error('Could not create directory: ' .. err)
			return false
		else
			return true
		end
	elseif attributes.mode ~= 'directory' then
		self._log.error('Path exists but is not a directory')
		return false
	else
		return true
	end
end

return DirectoryUtils

