-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local ffi = lazyRequire('ffi')
local json = lazyRequire('cjson')

local function serialize(node, matches)
	local nodeId   = node:getId()
	local payload = {}

	if #matches == 0 then
		payload[tostring(nodeId)] = nil
	else
		local nodeName = ffi.string(node:getName())
		local nodeType = ffi.string(node:getType())

		if nodeName == "" then
			nodeName = nil
		end

		local matchArray = {}

		for matchKey,matchValue in pairs(matches) do
			local rule = matchValue.rule
			local expr = matchValue.matchedExpression

			local match =
			{
				id = rule.ruleId,
				viewScope = rule.viewScope,
				selector = expr.rawString,
			}

			table.insert(matchArray, match)
		end

		payload[tostring(nodeId)] =
		{
			name = nodeName,
			type = nodeType,
			matches = matchArray
		}
	end

	local jsonPayload = json.encode(payload)

	-- Trim the leading and trailing {} object encapsulators, as we don't want to
	-- build a 'true' Json object, just a key/value pair
	jsonPayload = jsonPayload:sub(2, jsonPayload:len()-1)

	return jsonPayload
end

-- Public exports.
return
{
	serialize = serialize
}
