
local ffi = lazyRequire('ffi')
local djb2Hash = crypto.djb2Hash

--[[

	Symbol used for selecting nodes by their node type, e.g. "ImageNode"

  ]]--

local VALID_START_CHARACTERS  = '%a'
local VALID_MIDDLE_CHARACTERS = '%a'

return
{
	-- Friendly name for this symbol type
	name = 'node',

	-- Character to be used to begin this symbol in a selector. The pattern
	-- below matches any letter (upper or lowercase), which essentially means
	-- that node types don't have to be prefixed with anything at all.
	prefix = VALID_START_CHARACTERS,

	-- Function to be used to read this symbol from the raw selector string.
	-- This function will be called at the start of the symbol, and is expected
	-- to read until the end of the symbol, modifying the context as necessary.
	--
	-- Here we just keep reading until the end of the node type, and set the
	-- nodeType property of the current segment to the value we read.
	reader = function(segment, parseContext)

		-- Consume the full nodeType string
		segment.nodeType = parseContext:readUntilMatchFails(VALID_MIDDLE_CHARACTERS)
		segment.nodeTypeHash = djb2Hash(segment.nodeType)

	end,

	-- Function called when the number of occurrences of this symbol type in a
	-- given expression is being calculated. Supplied with a segment, the job
	-- of this function is just to return the number of symbols in the segment.
	counter = function(segment)

		-- As it's impossible to have more than one node type symbol in a given
		-- segment, we just return 1 if a node type was specified or 0 if the
		-- segment doesn't care what node type it matches (i.e. uses the wildcard)
		return (segment.nodeType ~= '*') and 1 or 0

	end
}