
local config = plugins.style:lazyRequire('selectors.config')
local SymbolLoader = plugins.style:lazyRequire('selectors.loaders.SymbolLoader')

local _countSymbolsMatchingTypes
local _symbolsByType = SymbolLoader.getSymbolsByType()

local SpecificityCalculator = {}

-- Calculates the specificity of the supplied expression, which is based on
-- the same rules used by CSS (for a good explanation of these rules see either
-- http://css-tricks.com/specifics-on-css-specificity/ or the official spec at
-- http://www.w3.org/TR/css3-selectors/#specificity).
--
-- Essentially, the number of symbols in the selector is what determines its
-- specificity, but different types of symbols have the ability to trump others
-- types even if there are fewer of them (this is equivalent to the way in which
-- ID selectors in CSS will always trump those comprised solely of classes, even
-- if the classes are more numerous).
--
-- The order in which this trumping is applied is determined by the specificity
-- list in selectors/config.lua (see the table named 'symbolSpecificity').
function SpecificityCalculator.calculate(expression)

	local symbolCounts = {}

	for i, types in ipairs(config.symbolSpecificity) do
		symbolCounts[i] = _countSymbolsMatchingTypes(types, expression)
	end

	return symbolCounts

end

function _countSymbolsMatchingTypes(symbolTypes, expression)

	local count = 0

	for i, symbolType in ipairs(symbolTypes) do
		local symbolDefinition = _symbolsByType[symbolType]

		for j, segment in ipairs(expression.segments) do
			-- Delegate the actual counting operation to the counter method provided
			-- by the symbol definition (see selectors/symbols/tag.lua for an example).
			count = count + symbolDefinition.counter(segment)
		end
	end

	return count

end

return SpecificityCalculator
