
local SelectorExpression = plugins.style:lazyRequire('selectors.SelectorExpression')

local ParseContext = class(function(self, selectorString)

	self._selectorString = selectorString
	self._index = 1
	self._expressions = {}
	self._segmentStartIndex = 1
	self._expressionStartIndex = 1

end)

function ParseContext:getSelectorString()
	return self._selectorString
end

function ParseContext:getLength()
	return #self._selectorString
end

function ParseContext:getIndex()
	return self._index
end

function ParseContext:setIndex(index)
	if (index == nil) then
		return
	end

	index = math.min(index, #self._selectorString + 1)
	index = math.max(index, 1)

	self._index = index
end

function ParseContext:isAtStart()
	return self._index <= 1
end

function ParseContext:isAtEnd()
	return self._index > self:getLength()
end

function ParseContext:getCharAt(index)
	local char = self._selectorString:sub(index, index)

	if (char == '') then
		return nil
	else
		return char
	end
end

function ParseContext:getCurrentChar()
	return self:getCharAt(self._index)
end

function ParseContext:getSubstring(startIndex, endIndex)
	return self._selectorString:sub(startIndex, endIndex)
end

-- Used for extracting the raw string that makes up the current segment
function ParseContext:flagSegmentStarted()
	self._segmentStartIndex = self._index
end

function ParseContext:getSegmentStartIndex()
	return self._segmentStartIndex
end

-- Used for extracting the raw string that makes up the current expression
function ParseContext:flagExpressionStarted()
	self._expressionStartIndex = self._index
end

function ParseContext:getExpressionStartIndex()
	return self._expressionStartIndex
end

function ParseContext:seek(delta)
	if delta == nil then
		delta = 1
	end

	local prevIndex = self._index

	self:setIndex(self._index + delta)

	return self._index ~= prevIndex
end

function ParseContext:peek(delta)
	if delta == nil then
		delta = 1
	end

	return self:getCharAt(self._index + delta)
end

function ParseContext:match(pattern)
	return self:getCurrentChar():match(pattern) ~= nil
end

function ParseContext:skipWhitespace()
	local start, finish = self._selectorString:find('%s*', self._index)

	self:setIndex(finish + 1)
end

function ParseContext:readUntilMatchFails(pattern)
	local value = ''

	while (self:isAtEnd() == false)
	  and (self:match(pattern)) do

		value = value .. self:getCurrentChar()
		self:seek()

	end

	return value
end

function ParseContext:addExpression()
	local expression = SelectorExpression.new()
	table.insert(self._expressions, expression)

	return expression
end

function ParseContext:getExpressions()
	return self._expressions
end

function ParseContext:getCurrentExpression()
	return self._expressions[#self._expressions]
end

return ParseContext
