-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

--
-- Class responsible for invalidating the relevant partition of the matchability
-- cache whenever a partition in the RuleSet changes.
--
local MatchabilityCacheInvalidator = class(function(
		self, 
		matchabilityCache, 
		ruleSet)

	self._matchabilityCache = matchabilityCache
	self._ruleSet = ruleSet

end)

function MatchabilityCacheInvalidator:startListening()
	if self._signalHandler == nil then
		self._signalHandler = function(partition)
			self._matchabilityCache:clearPartition(partition:getNameHash())
		end
	
		self._ruleSet.partitionModifiedSignal:add(self._signalHandler)
	end
end

function MatchabilityCacheInvalidator:stopListening()
	if self._signalHandler ~= nil then
		self._ruleSet.partitionModifiedSignal:remove(self._signalHandler)
		self._signalHandler = nil
	end
end

return MatchabilityCacheInvalidator