
local config = plugins.style:lazyRequire('selectors.config')

local _loadCombinators
local _printCombinatorError
local _combinatorDefinitions

local CombinatorLoader =
{
	getCombinatorsAsList = function()
		return _combinatorDefinitions
	end
}

function _loadCombinators()
	_combinatorDefinitions = {}

	local combinatorDefinition

	for key, name in pairs(config.combinationModes) do
		combinatorDefinition = plugins.style:lazyRequire('selectors.combinators.' .. name)

		if (type(combinatorDefinition.name) ~= 'string') then
			_printCombinatorError('Does not have a name', name)

		elseif (type(combinatorDefinition.character) ~= 'string') then
			_printCombinatorError('Does not specify a character', name)

		end

		table.insert(_combinatorDefinitions, combinatorDefinition)
	end
end

function _printCombinatorError(message, name)
	message = 'Error parsing combinator definition %q: ' .. message

	error(message:format(name))
end

_loadCombinators()

return CombinatorLoader
