
local Selector = class(function(self, rawString, expressions)

	self.rawString = rawString
	self.expressions = expressions

	self:_generateTagBloomFilters()

end)

-- Generates bloom filter for checking if a tag or set of tags are referenced by
-- a rule. The filter is 32 bits, each bit position representing a tag's hashcode
-- modulo 32
function Selector:_generateTagBloomFilters(rule)

	for i = 1, #self.expressions do
		local expression = self.expressions[i]
		local bloom = 0

		for j = 1, #expression.segments do
			local segment = expression.segments[j]
			for k = 1, #segment.tags do
				local tag = segment.tags[k]
				local mask = 2 ^ (tag.hash % 32)
				bloom = bit.bor(bloom, mask)
			end
			segment.bloom = bloom
		end
	end

end

return Selector

