
-- Provides a list of valid types that can be used as property values.
local PropertyTypes = class()

-- List of types supported by node properties.
local TYPES =
{
	INT = 'int',
	UINT = 'uint',
	FLOAT = 'float',
	STRING = 'string',
	BOOLEAN = 'boolean',
	VEC2 = 'Vec2',
	VEC3 = 'Vec3',
	VEC4 = 'Vec4',
	RECT = 'Rect',
	PIVOT_MODE = 'PivotMode'
}

-- Copy each supported type into the class, so that they're available by
-- referencing them statically (e.g. PropertyTypes.INT).
for i, v in pairs(TYPES) do
	PropertyTypes[i] = v
end

-- Reverse mapping of type constants to their keys, for use by the isValid method.
local REVERSE_TYPES = {}
for i, v in pairs(TYPES) do
	REVERSE_TYPES[v] = i
end

-- Checks that the supplied property type is present in the property types list.
function PropertyTypes.isValid(type)
	return (REVERSE_TYPES[type] ~= nil)
end

return PropertyTypes