-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local PropertyAccessDecorator = plugins.lua:lazyRequire('utils.PropertyAccessDecorator')

local _propertyAccessDecorator = PropertyAccessDecorator.new()

--
-- Small utility class which just encapsulates the use of PropertyAccessDecorator
-- for setting properties of nodes, along with the subsequent updating of any
-- bindings which are dependent upon the property value.
--
local PropertySetter = class(function(self, context)
	self._bindingManager = context:getBindingManager()
end)

function PropertySetter:setPropertyOfNode(node, name, value)
	_propertyAccessDecorator:setSubject(node)
	_propertyAccessDecorator[name] = value

	self._bindingManager
		:updateStaticWatchersByNodeIdAndPropertyName(node:getId(), name)
end

return PropertySetter



