-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local _idCounter = 0

--
-- Base class for all Styles
--
local AbstractStyle = class()

function AbstractStyle:_init(containingStyles)
	self._id = AbstractStyle.generateId()
	self._containingStyles = containingStyles
end

function AbstractStyle:getId()
	return self._id
end

function AbstractStyle:getContainingStyles()
	return self._containingStyles
end

function AbstractStyle.generateId()
	_idCounter = _idCounter + 1
	return _idCounter
end

return AbstractStyle



