-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local SignalQueue = class(function(self)
	self._signalQueue = {}
end)

SignalQueue.States =
{
	INCOMPLETE = "SignalQueue.States.INCOMPLETE",
	COMPLETE = "SignalQueue.States.COMPLETE"
}

function SignalQueue:queueSignal(node, signalName)
	self:_doubleKeySet(self._signalQueue, signalName, node, SignalQueue.States.INCOMPLETE)
end

function SignalQueue:completeSignal(node, signalName)
	self:_doubleKeySet(self._signalQueue, signalName, node, SignalQueue.States.COMPLETE)
end

function SignalQueue:dequeueSignal(node, signalName)
	self:_doubleKeyDelete(self._signalQueue, signalName, node)
end

function SignalQueue:isQueued(signalName)
	local isQueued = false

	if self._signalQueue[signalName] ~= nil then
		local node, signalState = next(self._signalQueue[signalName])
		isQueued = (signalState == SignalQueue.States.INCOMPLETE)
	end

	return isQueued
end

function SignalQueue:retrieveAndClearCompletedSignals()
	local signalsToReturn = {}

	for signalName, nodeToSignalState in pairs(self._signalQueue) do
		for node, signalState in pairs(nodeToSignalState) do

			if signalState == SignalQueue.States.COMPLETE then
				self:_doubleKeySet(signalsToReturn, signalName, node, signalState)
				self:_doubleKeyDelete(self._signalQueue, signalName, node)
			end

		end
	end

	return signalsToReturn
end

function SignalQueue:_doubleKeySet(doubleKeyTable, key1, key2, value)
	if doubleKeyTable[key1] == nil then
		doubleKeyTable[key1] = {}
	end

	doubleKeyTable[key1][key2] = value
end

function SignalQueue:_doubleKeyDelete(doubleKeyTable, key1, key2)
	if doubleKeyTable[key1] ~= nil then
		doubleKeyTable[key1][key2] = nil

		if(next(doubleKeyTable[key1]) == nil) then
			doubleKeyTable[key1] = nil
		end
	end
end

return SignalQueue