-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractNodeKeyword = plugins.style:lazyRequire('rules.keywords.AbstractNodeKeyword')

local SOURCE_NODE_TYPE = 'parent'

--
-- Node keyword used for reading from the current node's parent.
--
local ParentNodeKeyword = class(

	-- Parent class
	AbstractNodeKeyword,

	-- Constructor
	function(self, isLive)
		AbstractNodeKeyword._ctor(self, SOURCE_NODE_TYPE, isLive)
	end
)

ParentNodeKeyword.SOURCE_NODE_TYPE = SOURCE_NODE_TYPE

-- Traversal method for this NodeKeyword. For 'parent' nodes we just need to
-- call getParent() on the currentNode.
function ParentNodeKeyword:_doTraversal(currentNode)
	return currentNode:getParent()
end

-- Used for converting back from a table representation when transferring from
-- the definition state to the application state.
function ParentNodeKeyword.fromTable(table)
	return ParentNodeKeyword.new(table.isLive)
end

return ParentNodeKeyword
