-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local CurrentNodeKeyword = plugins.style:lazyRequire('rules.keywords.CurrentNodeKeyword')
local ParentNodeKeyword = plugins.style:lazyRequire('rules.keywords.ParentNodeKeyword')
local PreviousNodeKeyword = plugins.style:lazyRequire('rules.keywords.PreviousNodeKeyword')

local NodeKeywordFactory = class()

-- List of NodeKeyword class definitions, mapped to their source node type.
-- Note that this table must be updated when new NodeKeywords are added.
local _keywordClassesByType =
{
	[CurrentNodeKeyword.SOURCE_NODE_TYPE] = CurrentNodeKeyword,
	[ParentNodeKeyword.SOURCE_NODE_TYPE] = ParentNodeKeyword,
	[PreviousNodeKeyword.SOURCE_NODE_TYPE] = PreviousNodeKeyword
}

-- Used for instantiating NodeKeywords from their table based representation
-- when they've been transferred from the rule definition state to the rule
-- application state.
function NodeKeywordFactory.createKeywordFromTable(table)

	local keywordClass = _keywordClassesByType[table.sourceNodeType]
	local keywordInstance = keywordClass.fromTable(table)

	return keywordInstance

end

return NodeKeywordFactory
