-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local IExpressionBuilder = plugins.style:lazyRequire("expressions.definitions.builders.IExpressionBuilder")
local AbstractRuntimeExpression = plugins.style:lazyRequire("expressions.definitions.AbstractRuntimeExpression")

local RuleFinalizer = class(function(self)
end)

function RuleFinalizer:finalize(rule)
	self:_finalizeStyles(rule.styles)
end

function RuleFinalizer:_finalizeStyles(styles)
	for property, style in pairs(styles) do
		styles[property] = self:_finalizeStyle(style)
	end
end

function RuleFinalizer:_finalizeStyle(rhs)
	if self:_isBuildable(rhs) then
		rhs = rhs:build()
	end
	if self:_hasFinalizableStyles(rhs) then
		self:_finalizeStyles(rhs)
	end
	return rhs
end

function RuleFinalizer:_isBuildable(value)
	return self:_isValueInstanceOf(value, IExpressionBuilder)
end

function RuleFinalizer:_hasFinalizableStyles(value)
	return type(value) == "table" and
			not self:_isValueInstanceOf(value, AbstractRuntimeExpression)
end

function RuleFinalizer:_isValueInstanceOf(value, classDef)
	return type(value) == "table" and
			value.instanceOf and value:instanceOf(classDef)
end

return RuleFinalizer
