-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local Counter = plugins.style:lazyRequire('profiling.Counter')

local Counters = class()

function Counters.getCounts()	
	local counts = {}
	
	for name, counter in pairs(Counters) do
		if getmetatable(counter) == Counter then
			counts[name] = counter:getCount()
		end
	end
	
	return counts
end

return Counters
