-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local Counter = class(function(self, description, suffix)
	self._description = description
	self._suffix = suffix or ''
	self._count = 0
end)

function Counter:getDescription()
	return self._description
end

function Counter:getSuffix()
	return self._suffix
end

function Counter:getCount()
	return self._count
end

function Counter:setCount(count)
	self._count = count
end

function Counter:increment(value)
	if value == nil then
		value = 1
	end

	self._count = self._count + value
end

function Counter:reset()
	self._count = 0
end

return Counter
