-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.

local MutationType = plugins.style:lazyRequire('mutations.MutationType')

local SIZE_RELATED_PROPERTIES_2D = 
{
	width = true,
	height = true,
	compositeWidth = true,
	compositeHeight = true,
	top = true,
	bottom = true,
	left = true,
	right = true,
	compositeTop = true,
	compositeBottom = true,
	compositeLeft = true,
	compositeRight = true,
}

-- Maps each MutationType to a set of properties that are likely to be affected
-- by the mutation.
return
{
	[MutationType.TEXT_REFLOWED] = SIZE_RELATED_PROPERTIES_2D,
	[MutationType.INFERRED_DIMENSIONS_CHANGED] = SIZE_RELATED_PROPERTIES_2D
}