-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.

-- List of MutationTypes matching the enum in scene/mutations/MutationType.h
--
-- The two files must be kept in sync when making updates - any additions to
-- that file should be mirrored here.
local _enum = 
{
	CHILD_ADDED = 0,
	CHILD_REMOVED = 1,
	TAG_ADDED = 2,
	TAG_REMOVED = 3,
	INDEX_CHANGED = 4,
	TEXT_REFLOWED = 5,
	IMAGE_LOADED = 6,
	INFERRED_DIMENSIONS_CHANGED = 7,
	PARTITION_CHANGED = 8
}

local _reverseMapping = {}

local MutationType = class()

-- Expose each value from the enum as a static property of the MutationType
-- class, e.g. MutationType.CHILD_ADDED, MutationType.TAG_ADDED etc.
for name, value in pairs(_enum) do
	MutationType[name] = value
	_reverseMapping[value] = name
end

-- Provide a means for each enum value to be related back to its full name.
function MutationType.getName(enumValue)
	if type(enumValue) ~= 'number' then
		error('The value supplied to MutationType.getName() must be a number')
	end

	local name = _reverseMapping[enumValue]
	
	if name == nil then
		error('Could not retrieve a mutation type name for ' .. enumValue)
	end

	return name
end

return MutationType