-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local TableUtils = plugins.style:lazyRequire('utils.TableUtils')
local PropertyTypes = plugins.style:lazyRequire('rules.styles.definitions.PropertyTypes')
local TypeRuntimeExpression = plugins.style:lazyRequire('expressions.definitions.TypeRuntimeExpression')

--
-- Function representing the 'Vec3' type used for sizes/dimensions etc.
--
-- Generates a TypeRuntimeExpression for which will create a LuaVec3 CDATA when
-- evaluated at runtime.
--
return function(x, y, z)
	local values = { x, y, z }

	assert(#values == 3, 'Vec3 takes exactly three arguments')
	assert(TableUtils.allOfType(values, 'number'), 'Vec3 arguments must be numbers')

	return TypeRuntimeExpression.new(PropertyTypes.VEC3, values)
end
