-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local TableUtils = plugins.style:lazyRequire('utils.TableUtils')
local PropertyTypes = plugins.style:lazyRequire('rules.styles.definitions.PropertyTypes')
local TypeRuntimeExpression = plugins.style:lazyRequire('expressions.definitions.TypeRuntimeExpression')

--
-- Function representing the 'Vec2' type used for sizes/dimensions etc.
--
-- Generates a TypeRuntimeExpression for which will create a LuaVec2 CDATA when
-- evaluated at runtime.
--
return function(x, y)
	local values = { x, y }

	assert(#values == 2, 'Vec2 takes exactly two arguments')
	assert(TableUtils.allOfType(values, 'number'), 'Vec2 arguments must be numbers')

	return TypeRuntimeExpression.new(PropertyTypes.VEC2, values)
end
