-- Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local AbstractWatcher = plugins.style:lazyRequire('expressions.bindings.watchers.AbstractWatcher')
local PropertyGetter = plugins.style:lazyRequire('rules.styles.definitions.PropertyGetter')

local _propertyGetter = PropertyGetter.new()

--
-- Watcher used with PropertyRuntimeExpressions so that they may be re-evaluated
-- when a watched property of a node is updated.
--
local PropertyWatcher = class(

	-- Parent class
	AbstractWatcher,

	-- Constructor
	function(self, node, propertyRuntimeExpression)

		self:setNode(node)
		self._propertyRuntimeExpression = propertyRuntimeExpression
		self._propertyName = propertyRuntimeExpression:getPropertyName()
		self._cachedValue = self:_getWatchedValue()

	end
)

-- Returns the property being watched by this watcher.
function PropertyWatcher:getPropertyName()
	return self._propertyName
end

function PropertyWatcher:getPropertyRuntimeExpression()
	return self._propertyRuntimeExpression
end

function PropertyWatcher:getNode()
	return self._node
end

function PropertyWatcher:setNode(node)
	self._node = node
	self._nodeId = node:getId()
end

function PropertyWatcher:_getWatchedValue()
	return _propertyGetter:getPropertyOfNode(self._node, self._propertyName)
end

return PropertyWatcher



