-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local NumberComparator = plugins.lua:lazyRequire('utils.NumberComparator')
--
-- Base class for all watchers
--
local AbstractWatcher = class()

AbstractWatcher.normalizedFloatTolerance = 0.00001

-- Returns the node being watched by this watcher (if applicable).
function AbstractWatcher:getNode()
	return self._node
end

-- Returns the ID of the node being watched by this watcher (if applicable).
function AbstractWatcher:getNodeId()
	return self._nodeId
end

-- Returns the name of the property being watched by this watcher (if applicable).
function AbstractWatcher:getPropertyName()
	return self._propertyName
end

-- Returns the name of the variable being watched by this watcher (if applicable).
function AbstractWatcher:getVariableName()
	return self._variableName
end

-- Returns true if the watched value has been updated since the last time this
-- method was called
function AbstractWatcher:hasChangedSinceLastCall()

	local hasChanged
	local newValue   = self:_getWatchedValue()

	if type(self._cachedValue) == "number" and type(newValue) == "number" then
		hasChanged = not NumberComparator.almostEqual(
				self._cachedValue, newValue, self.normalizedFloatTolerance)
	else
		hasChanged = newValue ~= self._cachedValue
	end

	self._cachedValue  = newValue

	return hasChanged

end

function AbstractWatcher:getCachedValue()
	return self._cachedValue
end

function AbstractWatcher:isLive()
	return self._isLive
end

function AbstractWatcher:setIsLive(value)
	self._isLive = value
end

return AbstractWatcher



