-- Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.

-- List of all effects to be loaded. Each of these must correspond to an effect
-- definition in the effects/definitions folder.
local effectsList =
{
	'Alpha',
	'Blur',
	'Tint',
	'Fill',
	'Saturation',
	'Remove',
	'Border',
	'GrayScale',
	'Vignette',
	'LinearGradient',
	'SmoothLinearGradient',
	'SphericalAlpha',
	'GraduatedAlpha',
	'RadialProgressBar',
	'TextureTransform'
}

-- Loads each of the effects in the effects list, by default into the global
-- namespace. This behaviour can be changed by supplying a table as the first
-- argument - if one is supplied, the effects will be loaded into that table.
local function loadEffects(into)

	local namespace = into or _G

	for i, effectName in ipairs(effectsList) do
		namespace[effectName] = plugins.style:lazyRequire('effects.definitions.' .. effectName)
	end

end

-- Reverses the action of loadEffects(), either on the supplied table or on
-- the global namespace.
local function unloadEffects(from)

	local namespace = from or _G

	for i, effectName in ipairs(effectsList) do
		namespace[effectName] = nil
	end

end

-- Public exports.
return
{
	effectsList = effectsList,
	loadEffects = loadEffects,
	unloadEffects = unloadEffects
}
