-- Copyright 2015 Amazon.com, Inc. or its affiliates. All Rights Reserved.
local bit = require 'bit'

--
-- Important:
--   This has to be kept in sync with ISceneNode::InteractivityFlag enum
--
local interactivityMode =
{
	flagsEnum =
	{
		NONE                  = 0,
		FOCUS_ON_KEY_PRESS    = 1,
		FOCUS_ON_MOUSE_CLICK  = 2,
		SELECT_ON_MOUSE_CLICK = 4,
		MOUSE_HOVERABLE       = 8,
		FOCUS_ON_MOUSE_HOVER  = 16,
		VOICE                 = 32,
		TOUCH                 = 64,
		GESTURE               = 128,
		DEFAULT               = 0, -- NONE
		FOCUSABLE             = 7  -- 1 | 2 | 4
	},

	constructor = function(...)
		local mode = 0
		local args = {...}

		for i, arg in ipairs(args) do
			if type(arg) ~= "number" then
				log.error("InteractivityMode: argument #" .. i ..
						" must be a number.")
				return 0
			end

			mode = bit.bor(mode, arg)
		end

		return mode
	end
}

return interactivityMode
