/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_CAMERA_NODE_FFI_EXTERNS_H_
#define PLUGIN_SCENE_NODES_CAMERA_NODE_FFI_EXTERNS_H_

#include <scene/nodes/CameraNode.h>

#include <ffi/LuaFFIUserData.h>

#include <bindings/types/LuaVec2Binding.h>
#include <bindings/types/LuaVec3Binding.h>
#include <bindings/types/LuaVec4Binding.h>
#include <SceneConfig.h>

namespace ignition
{

CREATE_FFI_USER_DATA(CameraNode, scene);

namespace scene
{

// Required so that the LuaVec3/LuaVec4 etc structs can be referred to without their
// lua:: namespace prefix, which is necessary because the code will be imported
// directly into LuaFFI.
using namespace ::ignition::lua;

// Externed C functions to wrap each method belonging to our object

extern "C"
{
/* @begin_ffi_externs */

typedef struct CameraNodeUserData CameraNodeUserData;

PLUGINSCENE_API LuaVec3 scene_CameraNode_getCenter(CameraNodeUserData* self);
PLUGINSCENE_API void scene_CameraNode_setCenter(CameraNodeUserData* self, LuaVec3 center);

PLUGINSCENE_API LuaVec3 scene_CameraNode_getDirection(CameraNodeUserData* self);
PLUGINSCENE_API void scene_CameraNode_setDirection(CameraNodeUserData* self, LuaVec3 direction);

PLUGINSCENE_API LuaVec3 scene_CameraNode_getOriginalPosition(CameraNodeUserData* self);

/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_CAMERA_NODE_FFI_EXTERNS_H_
