/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_VIDEO_NODE_FFI_EXTERNS_H_
#define PLUGIN_SCENE_NODES_VIDEO_NODE_FFI_EXTERNS_H_

#include <scene/nodes/VideoNode.h>
#include <ffi/LuaFFIUserData.h>
#include <SceneConfig.h>

namespace ignition
{

CREATE_FFI_USER_DATA(VideoNode, scene);

namespace scene
{

// Externed C functions to wrap each method belonging to our object

extern "C"
{
/* @begin_ffi_externs */

typedef struct VideoNodeUserData VideoNodeUserData;

PLUGINSCENE_API uint32_t  scene_VideoNode_getVideoStreamId(VideoNodeUserData* self);
PLUGINSCENE_API void scene_VideoNode_setVideoStreamId(
		VideoNodeUserData* self, const uint32_t videoStreamId);

/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_VIDEO_NODE_FFI_EXTERNS_H_
