/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_TEXT_NODE_LUA_BINDINGS_H_
#define PLUGIN_SCENE_NODES_TEXT_NODE_LUA_BINDINGS_H_

#include <scene/nodes/TextNode.h>
#include <ffi/LuaFFIUserData.h>
#include <bindings/types/LuaVec2Binding.h>
#include <bindings/types/LuaVec3Binding.h>
#include <SceneConfig.h>

namespace ignition
{

CREATE_FFI_USER_DATA(TextNode, scene);

namespace scene
{
// Externed C functions to wrap each method belonging to our object

// Required so that the LuaVec2 struct can be referred to without its
// lua:: namespace prefix, which is necessary because the code will be imported
// directly into LuaFFI.
using namespace ::ignition::lua;

extern "C"
{
/* @begin_ffi_externs */

typedef struct TextNodeUserData TextNodeUserData;

PLUGINSCENE_API const char* scene_TextNode_getText(TextNodeUserData* self);
PLUGINSCENE_API const char* scene_TextNode_getFontFace(TextNodeUserData* self);
PLUGINSCENE_API const char* scene_TextNode_getLocale(TextNodeUserData* self);
PLUGINSCENE_API const char* scene_TextNode_getTruncationSequence(TextNodeUserData* self);
PLUGINSCENE_API float scene_TextNode_getFontSize(TextNodeUserData* self);
PLUGINSCENE_API int scene_TextNode_getFontWeight(TextNodeUserData* self);
PLUGINSCENE_API int scene_TextNode_getFontStyle(TextNodeUserData* self);
PLUGINSCENE_API float scene_TextNode_getLetterSpacing(TextNodeUserData* self);
PLUGINSCENE_API float scene_TextNode_getLineHeight(TextNodeUserData* self);
PLUGINSCENE_API int scene_TextNode_getParseMode(TextNodeUserData* self);
PLUGINSCENE_API int scene_TextNode_getTruncationMode(TextNodeUserData* self);
PLUGINSCENE_API LuaVec2 scene_TextNode_getWrapBounds(TextNodeUserData* self);
PLUGINSCENE_API LuaVec3 scene_TextNode_getFontColor(TextNodeUserData* self);
PLUGINSCENE_API int scene_TextNode_getAlignment(TextNodeUserData* self);
PLUGINSCENE_API int scene_TextNode_getVerticalAlignment(TextNodeUserData* self);

PLUGINSCENE_API void scene_TextNode_setText(
		TextNodeUserData* self, const char* text);
PLUGINSCENE_API void scene_TextNode_setLocale(
		TextNodeUserData* self, const char* locale);
PLUGINSCENE_API void scene_TextNode_setFontSize(
		TextNodeUserData* self, float size);
PLUGINSCENE_API void scene_TextNode_setTruncationSequence(
		TextNodeUserData* self, const char* truncationSequence);
PLUGINSCENE_API void scene_TextNode_setFontColor(
		TextNodeUserData* self, LuaVec3 color);
PLUGINSCENE_API void scene_TextNode_setFontHexColor(
		TextNodeUserData* self, const char* hexColor);
PLUGINSCENE_API void scene_TextNode_setFontFace(
		TextNodeUserData* self, const char* text);
PLUGINSCENE_API void scene_TextNode_setFontWeight(
		TextNodeUserData* self, int weight);
PLUGINSCENE_API void scene_TextNode_setFontStyle(
		TextNodeUserData* self, int style);
PLUGINSCENE_API void scene_TextNode_setLetterSpacing(
		TextNodeUserData* self, float spacing);
PLUGINSCENE_API void scene_TextNode_setLineHeight(
		TextNodeUserData* self, float height);
PLUGINSCENE_API void scene_TextNode_setParseMode(
		TextNodeUserData* self, int mode);
PLUGINSCENE_API void scene_TextNode_setTruncationMode(
		TextNodeUserData* self, int mode);
PLUGINSCENE_API void scene_TextNode_setWrapBounds(
		TextNodeUserData* self, LuaVec2 bounds);
PLUGINSCENE_API void scene_TextNode_setAlignment(
		TextNodeUserData* self, int alignment);
PLUGINSCENE_API void scene_TextNode_setVerticalAlignment(
		TextNodeUserData* self, int alignment);

/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_TEXT_NODE_LUA_BINDINGS_H_
