/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_SCENE_NODE_FFI_EXTERNS_H_
#define PLUGIN_SCENE_NODES_SCENE_NODE_FFI_EXTERNS_H_

#include <scene/nodes/SceneNode.h>
#include <SceneConfig.h>
#include <ffi/LuaFFIUserData.h>

#include <bindings/types/LuaReflectableValueBinding.h>
#include <bindings/types/LuaVec2Binding.h>
#include <bindings/types/LuaVec3Binding.h>
#include <bindings/types/LuaVec4Binding.h>
#include <bindings/types/LuaCuboidBinding.h>
#include <bindings/types/LuaPivotModeBinding.h>
#include <SceneConfig.h>

namespace ignition
{

CREATE_FFI_USER_DATA(SceneNode, scene);

namespace scene
{

// Required so that the LuaVec3/LuaVec4 etc structs can be referred to without their
// lua:: namespace prefix, which is necessary because the code will be imported
// directly into LuaFFI.
using namespace ::ignition::lua;
using namespace ::ignition::core;

// Externed C functions to wrap each method belonging to our object

extern "C"
{
/* @begin_ffi_externs */

typedef struct SceneNodeUserData SceneNodeUserData;

PLUGINSCENE_API bool scene_SceneNode_eq(SceneNodeUserData* self, SceneNodeUserData* other);
PLUGINSCENE_API void scene_SceneNode_gc(SceneNodeUserData* self);

PLUGINSCENE_API uint32_t scene_SceneNode_UNASSIGNED_CHILD_INDEX();

PLUGINSCENE_API bool scene_SceneNode_isRoot(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setIsRoot(SceneNodeUserData* self, bool value);

PLUGINSCENE_API SceneNodeUserData* scene_SceneNode_getParent(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setParent(SceneNodeUserData* self, SceneNodeUserData* parent);
PLUGINSCENE_API bool scene_SceneNode_hasParent(SceneNodeUserData* self);

PLUGINSCENE_API void scene_SceneNode_addChild(SceneNodeUserData* self, SceneNodeUserData* child);
PLUGINSCENE_API void scene_SceneNode_addChildBefore(SceneNodeUserData* self,
		SceneNodeUserData* child, SceneNodeUserData* beforeChild);
PLUGINSCENE_API void scene_SceneNode_addChildAfter(SceneNodeUserData* self,
		SceneNodeUserData* child, SceneNodeUserData* afterChild);
PLUGINSCENE_API void scene_SceneNode_addChildAt(SceneNodeUserData* self,
		SceneNodeUserData* child, uint32_t index);
PLUGINSCENE_API void scene_SceneNode_removeChild(SceneNodeUserData* self, SceneNodeUserData* child);
PLUGINSCENE_API uint32_t scene_SceneNode_getNumberOfChildren(SceneNodeUserData* self);
PLUGINSCENE_API uint32_t scene_SceneNode_getChildren(SceneNodeUserData* self, SceneNodeUserData* children[]);
PLUGINSCENE_API SceneNodeUserData* scene_SceneNode_getChildAtIndex(SceneNodeUserData* self, uint32_t index);
PLUGINSCENE_API uint32_t scene_SceneNode_getIndexOfChild(SceneNodeUserData* self, SceneNodeUserData* child);
PLUGINSCENE_API uint32_t scene_SceneNode_getIndexInParent(SceneNodeUserData* self);

PLUGINSCENE_API SceneNodeUserData* scene_SceneNode_getDescendantByName(SceneNodeUserData* self, const char* name);
PLUGINSCENE_API SceneNodeUserData* scene_SceneNode_getDescendantByUuid(SceneNodeUserData* self, uint32_t uuid);

PLUGINSCENE_API const char* scene_SceneNode_getType(SceneNodeUserData* self);
PLUGINSCENE_API const uint32_t scene_SceneNode_getTypeAsHash(SceneNodeUserData* self);
PLUGINSCENE_API bool scene_SceneNode_isType(SceneNodeUserData* self, const char* type);

PLUGINSCENE_API uint32_t scene_SceneNode_getId(SceneNodeUserData* self);

PLUGINSCENE_API const char* scene_SceneNode_getName(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setName(SceneNodeUserData* self, const char* name);

PLUGINSCENE_API const char* scene_SceneNode_getViewName(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setViewName(SceneNodeUserData* self, const char* viewName);

PLUGINSCENE_API LuaCuboid scene_SceneNode_getBounds(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getLeft(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getRight(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getTop(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getBottom(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getFront(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getBack(SceneNodeUserData* self);
PLUGINSCENE_API LuaCuboid scene_SceneNode_getWorldBounds(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getWorldLeft(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getWorldRight(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getWorldTop(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getWorldBottom(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getWorldFront(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getWorldBack(SceneNodeUserData* self);
PLUGINSCENE_API LuaCuboid scene_SceneNode_getScreenBounds(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getScreenLeft(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getScreenRight(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getScreenTop(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getScreenBottom(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getScreenFront(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getScreenBack(SceneNodeUserData* self);

PLUGINSCENE_API LuaCuboid scene_SceneNode_getCompositeBounds(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeLeft(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeRight(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeTop(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeBottom(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeFront(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeBack(SceneNodeUserData* self);

PLUGINSCENE_API void scene_SceneNode_setPivotPosition(SceneNodeUserData* self, LuaVec3 position);
PLUGINSCENE_API LuaVec3 scene_SceneNode_getPivotPosition(SceneNodeUserData* self);

PLUGINSCENE_API void scene_SceneNode_setPivotMode(SceneNodeUserData* self, LuaPivotMode pivotMode);
PLUGINSCENE_API LuaPivotMode scene_SceneNode_getPivotMode(SceneNodeUserData* self);

PLUGINSCENE_API LuaVec3 scene_SceneNode_getPosition(SceneNodeUserData* self);
PLUGINSCENE_API LuaVec3 scene_SceneNode_getWorldPosition(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setPosition(SceneNodeUserData* self, LuaVec3 position);

PLUGINSCENE_API float scene_SceneNode_getAlpha(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setAlpha(SceneNodeUserData* self, float alpha);

PLUGINSCENE_API float scene_SceneNode_getX(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setX(SceneNodeUserData* self, float x);
PLUGINSCENE_API float scene_SceneNode_getY(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setY(SceneNodeUserData* self, float y);
PLUGINSCENE_API float scene_SceneNode_getZ(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setZ(SceneNodeUserData* self, float z);

PLUGINSCENE_API LuaVec3 scene_SceneNode_getSize(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setSize(SceneNodeUserData* self, LuaVec3 size);

PLUGINSCENE_API float scene_SceneNode_getWidth(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setWidth(SceneNodeUserData* self, float width);
PLUGINSCENE_API float scene_SceneNode_getHeight(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setHeight(SceneNodeUserData* self, float height);
PLUGINSCENE_API float scene_SceneNode_getDepth(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setDepth(SceneNodeUserData* self, float depth);

PLUGINSCENE_API float scene_SceneNode_getCompositeWidth(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeHeight(SceneNodeUserData* self);
PLUGINSCENE_API float scene_SceneNode_getCompositeDepth(SceneNodeUserData* self);

PLUGINSCENE_API LuaVec3 scene_SceneNode_getScale(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setScale(SceneNodeUserData* self, LuaVec3 scale);

PLUGINSCENE_API float scene_SceneNode_getScaleX(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setScaleX(SceneNodeUserData* self, float x);
PLUGINSCENE_API float scene_SceneNode_getScaleY(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setScaleY(SceneNodeUserData* self, float y);
PLUGINSCENE_API float scene_SceneNode_getScaleZ(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setScaleZ(SceneNodeUserData* self, float z);

PLUGINSCENE_API LuaVec4 scene_SceneNode_getRotation(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setRotation(SceneNodeUserData* self, LuaVec4 rotation);

PLUGINSCENE_API float scene_SceneNode_getRotationAxisX(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setRotationAxisX(SceneNodeUserData* self, float x);
PLUGINSCENE_API float scene_SceneNode_getRotationAxisY(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setRotationAxisY(SceneNodeUserData* self, float y);
PLUGINSCENE_API float scene_SceneNode_getRotationAxisZ(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setRotationAxisZ(SceneNodeUserData* self, float z);
PLUGINSCENE_API float scene_SceneNode_getRotationAngle(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setRotationAngle(SceneNodeUserData* self, float w);

PLUGINSCENE_API void scene_SceneNode_setDrawIndex(SceneNodeUserData* self, int index);
PLUGINSCENE_API int scene_SceneNode_getDrawIndex(SceneNodeUserData* self);
PLUGINSCENE_API int scene_SceneNode_getHierarchicalDrawIndex(SceneNodeUserData* self);

PLUGINSCENE_API void scene_SceneNode_setLayer(SceneNodeUserData* self, uint8_t layer);
PLUGINSCENE_API uint8_t scene_SceneNode_getLayer(SceneNodeUserData* self);

PLUGINSCENE_API void scene_SceneNode_addMask(SceneNodeUserData* self, unsigned int mask);
PLUGINSCENE_API bool scene_SceneNode_addMaskNode(SceneNodeUserData* self, SceneNodeUserData* maskNodeUd);
PLUGINSCENE_API void scene_SceneNode_removeMask(SceneNodeUserData* self, unsigned int mask);
PLUGINSCENE_API bool scene_SceneNode_removeMaskNode(SceneNodeUserData* self, SceneNodeUserData* maskNodeUd);

PLUGINSCENE_API void scene_SceneNode_addEffect(
		SceneNodeUserData* self,
		const char* handle,
		const char* effect);
PLUGINSCENE_API void scene_SceneNode_removeEffect(
		SceneNodeUserData* self,
		const char* handle);
PLUGINSCENE_API bool scene_SceneNode_hasEffect(
		SceneNodeUserData* self,
		const char* handle);

PLUGINSCENE_API const char* scene_SceneNode_getEffectPropertyName(
		SceneNodeUserData* self,
		const char* handle,
		const char* effect,
		const char* property);
PLUGINSCENE_API uint32_t scene_SceneNode_getEffectPropertyIndex(
		SceneNodeUserData* self,
		const char* name);

PLUGINSCENE_API int scene_SceneNode_getEffectPropertyValueInt(
		SceneNodeUserData* self,
		uint32_t idx);
PLUGINSCENE_API float scene_SceneNode_getEffectPropertyValueFloat(
		SceneNodeUserData* self,
		uint32_t idx);
PLUGINSCENE_API LuaVec2 scene_SceneNode_getEffectPropertyValueVec2(
		SceneNodeUserData* self,
		uint32_t idx);
PLUGINSCENE_API LuaVec3 scene_SceneNode_getEffectPropertyValueVec3(
		SceneNodeUserData* self,
		uint32_t idx);
PLUGINSCENE_API LuaVec4 scene_SceneNode_getEffectPropertyValueVec4(
		SceneNodeUserData* self,
		uint32_t idx);

PLUGINSCENE_API void scene_SceneNode_setEffectPropertyValueInt(
		SceneNodeUserData* self,
		uint32_t idx,
		int value);
PLUGINSCENE_API void scene_SceneNode_setEffectPropertyValueFloat(
		SceneNodeUserData* self,
		uint32_t idx,
		float value);
PLUGINSCENE_API void scene_SceneNode_setEffectPropertyValueVec2(
		SceneNodeUserData* self,
		uint32_t idx,
		LuaVec2 value);
PLUGINSCENE_API void scene_SceneNode_setEffectPropertyValueVec3(
		SceneNodeUserData* self,
		uint32_t idx,
		LuaVec3 value);
PLUGINSCENE_API void scene_SceneNode_setEffectPropertyValueVec4(
		SceneNodeUserData* self,
		uint32_t idx,
		LuaVec4 value);

PLUGINSCENE_API bool scene_SceneNode_getVisible(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setVisible(SceneNodeUserData* self, bool visible);

PLUGINSCENE_API uint32_t scene_SceneNode_getInteractivityMode(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setInteractivityMode(SceneNodeUserData* self, uint32_t mode);
PLUGINSCENE_API bool scene_SceneNode_hasInteractivityFlag(
		SceneNodeUserData* self, uint32_t flag);

PLUGINSCENE_API bool scene_SceneNode_getFocusable(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setFocusable(SceneNodeUserData* self, bool isFocusable);

PLUGINSCENE_API int scene_SceneNode_getBlendMode(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setBlendMode(SceneNodeUserData* self, int mode);

PLUGINSCENE_API void scene_SceneNode_addTag(SceneNodeUserData* self, const char* tag);
PLUGINSCENE_API void scene_SceneNode_removeTag(SceneNodeUserData* self, const char* tag);
PLUGINSCENE_API bool scene_SceneNode_hasTag(SceneNodeUserData* self, const char* tag);
PLUGINSCENE_API bool scene_SceneNode_hasTagAsHash(SceneNodeUserData* self, uint32_t tag);
PLUGINSCENE_API void scene_SceneNode_getTags(SceneNodeUserData* self, const char* tags[]);
PLUGINSCENE_API void scene_SceneNode_getTagsAsHashes(SceneNodeUserData* self, uint32_t tags[]);
PLUGINSCENE_API uint32_t scene_SceneNode_numberOfTags(SceneNodeUserData* self);

PLUGINSCENE_API const char* scene_SceneNode_getPartition(SceneNodeUserData* self);
PLUGINSCENE_API uint32_t scene_SceneNode_getPartitionAsHash(SceneNodeUserData* self);
PLUGINSCENE_API void scene_SceneNode_setPartition(SceneNodeUserData* self, const char* name);

PLUGINSCENE_API void scene_SceneNode_generateMatchabilityInfo(SceneNodeUserData* self);
PLUGINSCENE_API const uint32_t* scene_SceneNode_getMatchabilityTagList(SceneNodeUserData* self);
PLUGINSCENE_API const uint32_t* scene_SceneNode_getMatchabilityTagCountList(SceneNodeUserData* self);
PLUGINSCENE_API const uint32_t* scene_SceneNode_getMatchabilityTagBloomFilterList(SceneNodeUserData* self);
PLUGINSCENE_API const uint32_t* scene_SceneNode_getMatchabilityViewNameList(SceneNodeUserData* self);
PLUGINSCENE_API const uint32_t* scene_SceneNode_getMatchabilityNodeTypeList(SceneNodeUserData* self);
PLUGINSCENE_API uint32_t scene_SceneNode_getMatchabilityKey(SceneNodeUserData* self);

PLUGINSCENE_API uint32_t scene_SceneNode_getPropertyIndex(
		SceneNodeUserData* self,
		const char* propertyName);
PLUGINSCENE_API ReflectableValueUserData* scene_SceneNode_getPropertyValue(
		SceneNodeUserData* self,
		uint32_t index);
PLUGINSCENE_API void scene_SceneNode_setPropertyValue(
		SceneNodeUserData* self,
		uint32_t index,
		ReflectableValueUserData* value);

PLUGINSCENE_API bool scene_SceneNode_isOnSceneGraph(SceneNodeUserData* self);

PLUGINSCENE_API const char* scene_SceneNode_toJson(
		SceneNodeUserData* self,
		bool recurse,
		int detailLevel);

/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_SCENE_NODE_FFI_EXTERNS_H_
