/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_MASK_NODE_FFI_EXTERNS_H_
#define PLUGIN_SCENE_NODES_MASK_NODE_FFI_EXTERNS_H_

#include <scene/nodes/MaskNode.h>
#include <ffi/LuaFFIUserData.h>
#include <SceneConfig.h>

namespace ignition
{

CREATE_FFI_USER_DATA(MaskNode, scene);

namespace scene
{

// Externed C functions to wrap each method belonging to our object

extern "C"
{
/* @begin_ffi_externs */

typedef struct MaskNodeUserData MaskNodeUserData;

PLUGINSCENE_API unsigned int scene_MaskNode_getStencilId(MaskNodeUserData* self);


/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_MASK_NODE_FFI_EXTERNS_H_
