/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_IMAGE_NODE_FFI_EXTERNS_H_
#define PLUGIN_SCENE_NODES_IMAGE_NODE_FFI_EXTERNS_H_

#include <scene/nodes/ImageNode.h>
#include <ffi/LuaFFIUserData.h>
#include <bindings/types/LuaRectBinding.h>
#include <SceneConfig.h>

namespace ignition
{

CREATE_FFI_USER_DATA(ImageNode, scene);

namespace scene
{

// Required so that the LuaRect structs can be referred to without their
// lua:: namespace prefix, which is necessary because the code will be imported
// directly into LuaFFI.
using namespace ::ignition::lua;

// Externed C functions to wrap each method belonging to our object

extern "C"
{
/* @begin_ffi_externs */

typedef struct ImageNodeUserData ImageNodeUserData;

PLUGINSCENE_API const char* scene_ImageNode_getFileType(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setFileType(ImageNodeUserData* self, const char* fileType);

PLUGINSCENE_API const char* scene_ImageNode_getSource(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setSource(ImageNodeUserData* self, const char* source);

PLUGINSCENE_API const char* scene_ImageNode_getCachePolicy(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setCachePolicy(ImageNodeUserData* self, const char* policy);

PLUGINSCENE_API int scene_ImageNode_getSourceChangeMode(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setSourceChangeMode(ImageNodeUserData* self, int mode);

PLUGINSCENE_API int scene_ImageNode_getImageLoadMode(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setImageLoadMode(ImageNodeUserData* self, int mode);

PLUGINSCENE_API int scene_ImageNode_getMipmappingMode(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setMipmappingMode(ImageNodeUserData* self, int mode);

PLUGINSCENE_API const char* scene_ImageNode_getKeyInImageRegistry(ImageNodeUserData* self);

PLUGINSCENE_API LuaRect scene_ImageNode_getSliceRect(ImageNodeUserData* self);
PLUGINSCENE_API void scene_ImageNode_setSliceRect(ImageNodeUserData* self,	LuaRect luaRect);


/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_IMAGE_NODE_FFI_EXTERNS_H_
