/* Copyright 2013 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_SCENE_NODES_CONTAINER_NODE_FFI_EXTERNS_H_
#define PLUGIN_SCENE_NODES_CONTAINER_NODE_FFI_EXTERNS_H_

#include <scene/nodes/ContainerNode.h>
#include <bindings/types/LuaVec4Binding.h>
#include <ffi/LuaFFIUserData.h>

namespace ignition
{

CREATE_FFI_USER_DATA(ContainerNode, scene);

namespace scene
{

using namespace ::ignition::lua;

// Externed C functions to wrap each method belonging to our object

extern "C"
{
/* @begin_ffi_externs */

typedef struct ContainerNodeUserData ContainerNodeUserData;

PLUGINSCENE_API LuaVec4 scene_ContainerNode_getBackgroundColor(
		ContainerNodeUserData* self);
PLUGINSCENE_API void scene_ContainerNode_setBackgroundColor(
		ContainerNodeUserData* self, LuaVec4 color);

/* @end_ffi_externs */
}

} // namespace scene
} // namespace ignition

#endif // PLUGIN_SCENE_NODES_CONTAINER_NODE_FFI_EXTERNS_H_
