/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_TASKS_RENDER_TASK_H_
#define PLUGIN_RENDERER_TASKS_RENDER_TASK_H_

#include "RendererConfig.h"
#include <Function.h>

#include <string>
#include <stdint.h>

namespace ignition
{

namespace renderer
{

typedef core::function<void()> TaskCallback;

struct PLUGINRENDERER_API RenderTask
{
	RenderTask(
			const std::string& name,
			uint16_t priority,
			const TaskCallback& callback);

	bool operator >(const RenderTask& rhs) const;

	std::string name;
	uint16_t priority;
	TaskCallback callback;
};

} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_TASKS_RENDER_TASK_H_
