/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_EVENTS_EARLY_PLAY_EVENT_H_
#define PLUGIN_RENDERER_EVENTS_EARLY_PLAY_EVENT_H_

// core
#include <event/events/Event.h>
#include <event/EventHandler.h>

namespace ignition
{
namespace renderer
{

class EarlyPlayEvent : public core::event::Event
{
	REGISTER_EVENT(EarlyPlayEvent);

public:
	static const core::event::EventName ENABLE_BLITTING;
	static const core::event::EventName DISABLE_BLITTING;

	static EarlyPlayEvent* create(
			const core::event::EventName name,
			const core::UUID& sender,
			unsigned int fadeDurationMs);

	static EarlyPlayEvent* clone(const EarlyPlayEvent& rhs);
	static EarlyPlayEvent& cast(core::event::Event& event);

	EarlyPlayEvent(const EarlyPlayEvent& other);
	EarlyPlayEvent& operator=(const EarlyPlayEvent& rhs);

	unsigned int getFadeDurationMs() const;

	void accept(core::event::EventHandler* const handler, core::event::Context& ctx);

protected:
	EarlyPlayEvent(
			const core::event::EventName name,
			const core::UUID& sender,
			unsigned int fadeDurationMs);

	unsigned int _fadeDurationMs;
};

} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_EVENTS_EARLY_PLAY_EVENT_H_
