#version 100

attribute highp   vec4 a_position;
attribute lowp    vec4 a_color;

uniform highp mat4 u_model_matrix;
uniform highp mat4 u_view_projection_matrix;

varying   lowp    vec4 v_color;

void main(void)
{
  v_color = a_color;
  gl_Position = u_view_projection_matrix * u_model_matrix * a_position;
}
