/* Copyright 2014 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

#ifndef PLUGIN_RENDERER_VIDEO_VIDEO_FRAME_BROADCASTER_H_
#define PLUGIN_RENDERER_VIDEO_VIDEO_FRAME_BROADCASTER_H_

// Renderer
#include "RendererConfig.h"
#include "video/IVideoFrameReceiver.h"
#include "video/VideoFrame.h"

// Core
#include <SmartPointers.h>
#include <DataStructures.h>
#include <core/thread/Mutex.h>

namespace ignition
{
namespace renderer
{

class IRenderer;

namespace video
{

class PLUGINRENDERER_API VideoFrameBroadcaster
{
public:
	virtual ~VideoFrameBroadcaster();
	virtual void init(IRenderer& renderer) = 0;

	void setVideoFrameReceiver(VideoFrameReceiverPtr videoFrameReceiver);
	VideoFrameReceiverPtr getVideoFrameReceiver();

protected:
	void _raiseVideoFrameReady(VideoFrame& videoFrame);

	VideoFrameReceiverPtr _videoFrameReceiver;
};

} // namespace video
} // namespace renderer
} // namespace ignition

#endif // PLUGIN_RENDERER_VIDEO_VIDEO_FRAME_BROADCASTER_H_
